<?php

namespace App\Http\Controllers\Admin;

use App\Categories;
use App\Http\Controllers\Controller;
use App\Libraries\Utils;
use App\Pages;
use App\Users;
use Illuminate\Support\Str;
use Input;
use Session;

class PagesController extends Controller
{

    public function create()
    {
        $admins = Utils::getUsersInGroup(Users::TYPE_ADMIN);

        return view('admin.pages.create', ['categories' => Categories::all(), 'admins' => $admins]);
    }

    public function store()
    {

        if (!Input::has('title')) {
            Session::flash('error_msg', 'Page title is required');
            return redirect()->back()->withInput(Input::all());
        }

        $page = new Pages();
        $page->title = Input::get('title');
        $page->description = Input::get('description');
        $page->slug = Str::slug(Input::get('title'));
        $page->show_in_menu = Input::has('show_in_menu') ? 1 : 0;
        $page->show_in_sidebar = Input::has('show_in_sidebar') ? 1 : 0;
        $page->show_in_footer = Input::has('show_in_footer') ? 1 : 0;
        $page->seo_keywords = Input::get('seo_keywords', Input::get('name'));
        $page->seo_description = Input::get('seo_description', Input::get('name'));
        $page->status = Input::get('status');
        $page->author_id = Input::get('author');
        $page->save();

        Session::flash('success_msg', 'Page created successfully');
        return redirect()->to('/admin/pages/all');

    }

    public function edit($id)
    {

        $admins = Utils::getUsersInGroup(Users::TYPE_ADMIN);

        if (!is_null($id) && sizeof(Pages::where('id', $id)->get()) > 0) {

            $page = Pages::where('id', $id)->first();
            return view('admin.pages.edit', ['page' => $page,'admins' => $admins]);

        } else {
            Session::flash('error_msg', 'Page not found');
            return redirect()->to('/admin/pages/all');
        }

    }

    public function delete($id)
    {
        if (!is_null($id) && sizeof(Pages::where('id', $id)->get()) > 0) {

            Pages::where('id', $id)->delete();

            Session::flash('success_msg', 'Page deleted successfully');
            return redirect()->to('/admin/pages/all');

        } else {
            Session::flash('error_msg', 'Page not found');
            return redirect()->to('/admin/pages/all');
        }
    }

    public function update()
    {

        if (Input::has('id') && sizeof(Pages::where('id', Input::get('id'))->get()) > 0) {

            if (sizeof(Pages::where('title', Input::get('title'))->where('id', '!=', Input::get('id'))->get()) > 0) {
                Session::flash('error_msg', 'Page with given title already exists');
                return redirect()->back()->withInput(Input::all());
            }

            $page = Pages::where('id', Input::get('id'))->first();

            $page->title = Input::get('title');
            $page->slug = Str::slug(Input::get('title'));
            $page->description = Input::get('description');
            $page->show_in_menu = Input::has('show_in_menu') ? 1 : 0;
            $page->show_in_sidebar = Input::has('show_in_sidebar') ? 1 : 0;
            $page->show_in_footer = Input::has('show_in_footer') ? 1 : 0;
            $page->seo_keywords = Input::get('seo_keywords', Input::get('name'));
            $page->seo_description = Input::get('seo_description', Input::get('name'));
            $page->status = Input::get('status');
            $page->author_id = Input::get('author');
            $page->save();

            Session::flash('success_msg', 'Page updated successfully');
            return redirect()->to('/admin/pages/all');

        } else {
            Session::flash('error_msg', 'Page not found');
            return redirect()->to('/admin/pages/all');
        }

    }

    public function all()
    {

        $pages = Pages::all();

        return view('admin.pages.all', ['pages' => $pages]);
    }

}